//////////////////////////////////////////////
// Environment.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkScriptsTests.Environment = class Environment extends nkDebug.TestClass
{
	static instance = new Environment ("nkScriptsTests.Environment") ;

	nkTests =
	{
		__testShutdown__ : function ()
		{
			nkScripts.EnvironmentManager.kill() ;
			nkScripts.ScriptManager.kill() ;
		},
		
		GoodExecution : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("return 5") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;

			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;

			const executionResult = env.getLastExecutionResult() ;
			nkDebug.TestUtils.check(executionResult._success, "Execution result success mismatch") ;
			nkDebug.TestUtils.check(executionResult._failureType === nkScripts.EXECUTION_FAILURE_TYPE.NO_ERROR, "Failure type mismatch") ;
		},

		BadExecutionFunctionFailure : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("pirnt('bark')") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;

			nkDebug.TestUtils.check(!env.execute(script), "Execution should be failing") ;

			const executionResult = env.getLastExecutionResult() ;
			nkDebug.TestUtils.check(!executionResult._success, "Execution result success mismatch") ;
			nkDebug.TestUtils.check(executionResult._failureType === nkScripts.EXECUTION_FAILURE_TYPE.RUNTIME, "Failure type mismatch") ;
		},

		BadExecutionVarFailure : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("return x + 1") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;

			nkDebug.TestUtils.check(!env.execute(script), "Execution should be failing") ;

			const executionResult = env.getLastExecutionResult() ;
			nkDebug.TestUtils.check(!executionResult._success, "Execution result success mismatch") ;
			nkDebug.TestUtils.check(executionResult._failureType === nkScripts.EXECUTION_FAILURE_TYPE.RUNTIME, "Failure type mismatch") ;
		},

		GetBoolean : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = {y = {v = false}}") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;

			const v = env.getVarBool("x.y.v", true) ;
			nkDebug.TestUtils.check(!v, "Wrong value output") ;
		},

		GetInt : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = {y = {v = 1}}") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;

			const v = env.getVarInt("x.y.v", 0) ;
			nkDebug.TestUtils.check(v === 1, "Wrong value output") ;
		},

		GetFloat : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = {y = {v = 1.1}}") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;

			const v = env.getVarFloat("x.y.v", 0) ;
			nkDebug.TestUtils.check(v === 1.1, "Wrong value output") ;
		},

		GetString : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = {y = {v = 'test'}}") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;

			const v = env.getVarString("x.y.v", "") ;
			nkDebug.TestUtils.check(v === "test", "Wrong value output") ;
		},

		SetBoolVarGoodVisibilityFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarBool("x", true) ;
			nkDebug.TestUtils.check(env.isVarSet("x"), "Variable set yet not existing") ;
		},

		SetIntVarGoodVisibilityFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarInt("x", 1) ;
			nkDebug.TestUtils.check(env.isVarSet("x"), "Variable set yet not existing") ;
		},

		SetFloatVarGoodVisibilityFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarFloat("x", 1.1) ;
			nkDebug.TestUtils.check(env.isVarSet("x"), "Variable set yet not existing") ;
		},

		SetStringVarGoodVisibilityFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarString("x", "test") ;
			nkDebug.TestUtils.check(env.isVarSet("x"), "Variable set yet not existing") ;
		},

		SetBoolVarGoodReadingFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarBool("x", true) ;
			nkDebug.TestUtils.check(true === env.getVarBool("x", false), "Variable value mismatch") ;
		},

		SetIntVarGoodReadingFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarInt("x", 1) ;
			nkDebug.TestUtils.check(1 === env.getVarInt("x", 0), "Variable value mismatch") ;
		},

		SetFloatVarGoodReadingFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarFloat("x", 1.1) ;
			nkDebug.TestUtils.check(1.1 === env.getVarFloat("x", 0), "Variable value mismatch") ;
		},

		SetStringVarGoodReadingFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isVarSet("x"), "Variable not set yet existing") ;
			env.setVarString("x", "test") ;
			nkDebug.TestUtils.check("test" === env.getVarString("x", ""), "Variable value mismatch") ;
		},

		SetNamespaceGoodVisibilityFromC : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			nkDebug.TestUtils.check(!env.isNamespaceSet("ns"), "Namespace not set yet existing") ;
			env.setNamespace("ns") ;
			nkDebug.TestUtils.check(env.isNamespaceSet("ns"), "Namespace set yet not existing") ;
		},

		SetNamespaceGoodVisibilityFromLua : function ()
		{
			const env = nkScripts.EnvironmentManager.getInstance().createOrRetrieve("env") ;
			env.setEnvironmentFor(nkScripts.INTERPRETER.LUA) ;

			const script = nkScripts.ScriptManager.getInstance().createOrRetrieve("script") ;
			script.setTargetInterpreter(nkScripts.INTERPRETER.LUA) ;
			script.setSources("x = ns ; v = x ~= nil ;") ;
			nkDebug.TestUtils.check(script.load(), "Script should load") ;
			
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(!env.getVarBool("v", true), "Value mismatch before namespace creation")
			
			env.setNamespace("ns") ;
			nkDebug.TestUtils.check(env.execute(script), "Execution should be successful") ;
			nkDebug.TestUtils.check(env.getVarBool("v", false), "Value mismatch after namespace creation")
		}
	}
}